package w83b.w83bOperacionesInternas.w83bPreavisos;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaException;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bPreavisosAnyadirOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
				
		if (contexto.get("w83bMapaFilePreavisos")!=null){
			W83bPreavisosBean preaviso = (W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");

			preaviso.setCodPromotor("");
			HashMap mapaFiles =(HashMap)contexto.get("w83bMapaFilePreavisos");
			Iterator iter = mapaFiles.keySet().iterator();
			W83bDocBean docBean=null;
			while (iter.hasNext())
			{
				HashMap datosFile=(HashMap)mapaFiles.get(iter.next());
				docBean= new W83bDocBean();//NOPMD
				docBean.setNombre((String)datosFile.get("nombreDocumento"));
				docBean.setCodFase(((String)datosFile.get("tipodocumento")).split("_")[1]);
				docBean.setTipoDocumento(((String)datosFile.get("tipodocumento")).split("_")[0]);
				docBean.setCodTramite(((String)datosFile.get("tipodocumento")).split("_")[2]);
				docBean.setFechaRegistro((String)datosFile.get("fecharegistro"));
				docBean.setUsuario((String)datosFile.get("usuario"));
				docBean.setNumeroRegistro((String)datosFile.get("numregistro"));
				docBean.setFileData((InputStream)datosFile.get("documentoStream"));
				docBean.setTamanyo(((Long)datosFile.get("tamanyo")).intValue());
				preaviso.getListaDocs().add(docBean);

			}
		}
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		String resultado = (String)contexto.get("w83bResultado");
		
		int fechaRegistro = resultado.split("___").length;
		
		resultado = resultado.split("___")[0];
		
		contexto.set("w83bResultado",resultado);
		
		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.baseDatosLlena", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if("-2".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.codPreavisoyaExiste", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if(1==fechaRegistro){
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOkLibroRegistroError");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("codSelecEdicion",resultado);
		}else{
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("codSelecEdicion",resultado);

		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
	
	protected void processOIException(Q70ContextoEJIE paramQ70ContextoEJIE, Exception paramException, Q70OperacionInternaErrors paramQ70OperacionInternaErrors)
	throws Exception{
		if(null!=paramException&&null!=((Q70OperacionInternaException)paramException).getPrimaryException() && ((Q70OperacionInternaException)paramException).getPrimaryException() instanceof W83bLibroRegistroException){
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError("error.mensaje.errorRegistroEntrada"));
		}else{
			paramQ70OperacionInternaErrors.add("OI_ERROR", new Q70OperacionInternaError(getConfiguracion().getOiErrorKey()));			
		}
	}
}